/*! \file tlk_odrm_errors.h
**********************************************************************************
*Title:                        Discretix OMA DRM v2 Toolkit header file
*
* Filename:                     tlk_odrm_errors.h
*
* Project, Target, subsystem:   Toolkit, OMA DRM
* 
* Created:                      20.11.2007
*
* Modified:                     20.11.2007
*
* \Author                       Ira Boguslavsky
*
* \Remarks
*           Copyright (C) 2007 by Discretix Technologies Ltd. All Rights reserved.
**********************************************************************************/
#ifndef _TLK_ODRM_ERRORS_H_
#define _TLK_ODRM_ERRORS_H_

#ifdef __cplusplus
extern "C" {
#endif

/*----------- OMA DRM Toolkit Error definitions----------------------------------*/
/*! \brief OMA DRM Toolkit API Return Codes base                                **/
#define TLK_ODRM_RC_ERROR_BASE                           (0xBF000000UL)

/*! \brief Operation completed successfully                                     **/
#define TLK_ODRM_RC_OK                                   (0x00000000UL)

/*! \brief Operation failed                                                     **/
#define TLK_ODRM_RC_FAIL                                 (TLK_ODRM_RC_ERROR_BASE+0x02)

/*! \brief CRYS KMNG operation failed                                           **/
#define TLK_ODRM_RC_ERROR_CRYS_KMNG                      (TLK_ODRM_RC_ERROR_BASE+0x03)

/*! \brief KMNG operation failed                                               **/
#define TLK_ODRM_RC_ERROR_KMNG                           (TLK_ODRM_RC_ERROR_BASE+0x04)

/*! \brief CRYS operation failed                                               **/
#define TLK_ODRM_RC_ERROR_CRYS                           (TLK_ODRM_RC_ERROR_BASE+0x05)

/*! \brief AES operation mode invalid (allowed CBC or CTR)                     **/
#define TLK_ODRM_RC_ERROR_AES_OPERATION_MODE             (TLK_ODRM_RC_ERROR_BASE+0x06)

/*! \brief CRYS KDF operation failed                                           **/
#define TLK_ODRM_RC_ERROR_CRYS_KDF                       (TLK_ODRM_RC_ERROR_BASE+0x07)

/*! \brief Can not get key from the key ring                                   **/
#define TLK_ODRM_RC_ERROR_GET_KEY_FROM_KEY_RING          (TLK_ODRM_RC_ERROR_BASE+0x08)

/*! \brief Can not store key from the key ring                                 **/
#define TLK_ODRM_RC_ERROR_STORE_KEY_IN_KEY_RING          (TLK_ODRM_RC_ERROR_BASE+0x09)

/*! \brief Workspace address not align                                         **/
#define TLK_ODRM_RC_ERROR_WORKSPACE_NOT_ALIGN            (TLK_ODRM_RC_ERROR_BASE+0x0A)
    
/*! \brief Workspace size is not big enough or workspace address is NULL       **/
#define TLK_ODRM_RC_ERROR_WORKSPACE                      (TLK_ODRM_RC_ERROR_BASE+0x0B)

/*! \brief Some of parameters are NULL pointers                                **/
#define TLK_ODRM_RC_ERROR_NULL_POINTER                   (TLK_ODRM_RC_ERROR_BASE+0x0C)

/*! \brief Size of C string is incorrect                                       **/
#define TLK_ODRM_RC_ERROR_C_SIZE                         (TLK_ODRM_RC_ERROR_BASE+0x0D)

/*! \brief Generation number is incorrect                                       **/
#define TLK_ODRM_RC_ERROR_GENERATION_NUMBER              (TLK_ODRM_RC_ERROR_BASE+0x0E)

/*! \brief Cannot get protected key from key ring                               **/
#define TLK_ODRM_RC_ERROR_GET_PROT_KEY_FROM_KEY_RING     (TLK_ODRM_RC_ERROR_BASE+0x0F)

/*! \brief Invalid Password size of the input parameter                         **/
#define TLK_ODRM_RC_ERROR_INVALID_PASSWORD_SIZE          (TLK_ODRM_RC_ERROR_BASE+0x10)

/*! \brief Invalid buffer size of the input parameter                           **/
#define TLK_ODRM_RC_ERROR_INVALID_BUFFER_SIZE            (TLK_ODRM_RC_ERROR_BASE+0x11)

/*! \brief Mac verification failed for Domain Key								**/
#define TLK_ODRM_RC_ERROR_DOMAIN_KEY_MAC	            (TLK_ODRM_RC_ERROR_BASE+0x12)

/*! \brief Domain Name not found in domain RO									**/
#define TLK_ODRM_RC_ERROR_RO_DOMAIN_NOT_FOUND	       (TLK_ODRM_RC_ERROR_BASE+0x13)

/*! \brief Tag missing in RO XML												**/
#define TLK_ODRM_RC_ERROR_RO_XML_TAG_NOT_FOUND	       (TLK_ODRM_RC_ERROR_BASE+0x14)

/*! \brief RO hash does not match hash in signed data							**/
#define TLK_ODRM_RC_ERROR_RO_HASH_CHECK			       (TLK_ODRM_RC_ERROR_BASE+0x15)

/*! \brief Mac verification failed for ro										**/
#define TLK_ODRM_RC_ERROR_RO_MAC_VERIFICATION_FAILED   (TLK_ODRM_RC_ERROR_BASE+0x16)

/*! \brief digest verification failed for ro									**/
#define TLK_ODRM_RC_ERROR_RO_DIGEST_VERIFICATION_FAILED   (TLK_ODRM_RC_ERROR_BASE+0x17)

/*! \brief no valid rights for the requested content found in the RO			**/
#define TLK_ODRM_RC_ERROR_NO_VALID_RIGTHS_FOUND_IN_RO   (TLK_ODRM_RC_ERROR_BASE+0x18)

/*! \brief no encrypted CEK for requested asset fround in RO					**/
#define TLK_ODRM_RC_ERROR_ENCRYPTED_CEK_NOT_FOUND_IN_RO  (TLK_ODRM_RC_ERROR_BASE+0x19)

/*! \brief group key expected for asset ID but not given						**/
#define TLK_ODRM_RC_ERROR_MISSING_GROUP_KEY			     (TLK_ODRM_RC_ERROR_BASE+0x1a)

/*! \brief end of ro XMl element not found (</roap:ro>)							**/
#define TLK_ODRM_RC_ERROR_MISSING_ROAP_ELEMENT_END	     (TLK_ODRM_RC_ERROR_BASE+0x1b)

/*! \brief end of ro XMl element not found (</ds:SignedInfo>)					**/
#define TLK_ODRM_RC_ERROR_MISSING_SIGNED_INFO_ELEMENT_END (TLK_ODRM_RC_ERROR_BASE+0x1c)

/*! \brief group key size given is invalid										**/
#define TLK_ODRM_RC_ERROR_INVALID_GROUP_KEY_SIZE	      (TLK_ODRM_RC_ERROR_BASE+0x1a)

/*! \brief domain key xml parsing failed to find a needed element.				**/
#define TLK_ODRM_RC_ERROR_DOMAIN_KEY_PARSING_FAILED	      (TLK_ODRM_RC_ERROR_BASE+0x1b)

/*! \brief RO Xml parsing for verification failed to find a needed element 		**/
#define TLK_ODRM_RC_ERROR_RO_XML_VERIFICATION_PARSING_FAILED  (TLK_ODRM_RC_ERROR_BASE+0x1c)

/*! \brief RO Xml parsing for verification failed to find a needed element		**/
#define TLK_ODRM_RC_ERROR_RO_XML_USAGE_PARSING_FAILED	      (TLK_ODRM_RC_ERROR_BASE+0x1d)

/*! \brief Can not get key from the key ring                                   **/
#define TLK_ODRM_RC_ERROR_GET_KEY_INFO_FAILED				(TLK_ODRM_RC_ERROR_BASE+0x1e)

/*! \brief Can not get key from the key ring                                   **/
#define TLK_ODRM_RC_ERROR_INCORRECT_KEY_PERMISSIONS        (TLK_ODRM_RC_ERROR_BASE+0x1f)

#ifdef __cplusplus
}
#endif 

#endif
